(*|  0:59 29/06/1996 *)
UNIT DirCollection;

INTERFACE

USES Dos, FileSrch, Objects;

VAR
  DirCol,DosDirCol: TStringCollection;

FUNCTION InitDirCol: Byte;

PROCEDURE SaveDirCol(FileName: String);

FUNCTION LoadDirCol(FileDir, FileName: String; Rebuild: Boolean): Byte;

IMPLEMENTATION

CONST
  DirNameLen = 14;  { mod by BW. New conts, 14 was 10, hard coded }

VAR
  DirCount: Integer;
  DirSize: LongInt;

PROCEDURE StoreName(VAR S:SearchRec; P:PathStr); FAR;
VAR
  TS: String;
  P1, P2, T1: Byte;
BEGIN
  IF (S.Name[1] <> '.') AND (S.Attr AND Directory > 0 ) THEN BEGIN
    P := P + S.Name;
    {-fill string TS with spaces-}
    FillChar(TS[3], 128, ' ');     {mod by BW. 128 was 78}
    {-start TS with a space and a tee character-}
    TS[1] := ' ';
    TS[2] := #195;
    P1 := 4;
    T1 := 4;
    WHILE P1 <= Length(P) DO BEGIN
      {-locate one subdirector name...-}
      P2 := P1;
      WHILE (P2 <= Length(P)) AND (P[P2] <> '\') DO
        INC(P2);
      {-...and move it into string TS-}
      MOVE(P[P1], TS[T1], P2-P1);
      INC(T1, DirNameLen);
      P1 := SUCC(P2);
    END;
    DEC(T1);
    WHILE TS[T1] = #196 DO
      DEC(T1);
    TS[0] := Char(T1);
    INC(DirCount);
    INC(DirSize,T1);
    Writeln(DirCount:3,' ',T1,' ',TS);
    DirCol.Insert(NewStr(TS));
  END;
END;  { StoreName }

PROCEDURE FixCol;
VAR
  A, B, OldA, OldB: String;
  PA, PB: PString;
  W: Word;
  P, Q: Byte;
  Change: Boolean;

  PROCEDURE EnLine(VAR S: String);
  VAR
    I: Integer;
  BEGIN
    FOR I := 2 TO Length(S) DO
      IF S[I] = ' ' THEN
        S[I] := #196;
  END;  { EnLine }

  FUNCTION Same(X, Y: String): Byte;
  { Returns the position of the first subdirectory }
  { for which the two strings are no longer the same }
  VAR
    P: Byte;
  BEGIN
    P := 3;
    REPEAT
      INC(P);
    UNTIL (P > Length(X)) OR (P > Length(Y)) OR (X[P] <> Y[P]);
    Same := 2+(((P-4) DIV DirNameLen) * DirNameLen);
  END;  { Same }

BEGIN
  PA := PString(DirCol.At(0));
  A := PA^;
  EnLine(A);
  OldA := A;
  W := 1;
  Writeln('Reformatting directory data');
{ Writeln('Memory :  ',MemAvail,',  ',MaxAvail,',  ',DirSize);}
  WHILE W < DirCol.count DO BEGIN
    PB := PString(DirCol.At(W));
    B := PB^;
    EnLine(B);
    OldB := B;
(*
    IF POS(OldA, B) > 0 THEN BEGIN
      MOVE(A[1], B[1], Length(A));
      A := A+','; {signal to delete later}
    END ELSE
*)
    BEGIN
      P := Same(OldA, B);
      IF P > 2 THEN BEGIN
        FIllChar(B[1], P, ' ');
        Q := 2;
        WHILE Q <= P DO BEGIN
          IF A[Q] = #196 THEN
            A[Q] := #194;
          B[Q] := #179;
          INC(Q, DirNameLen);
        END; {WHILE Q}
        B[P] := #195;
      END;
      Q := POS(#195, A);
      IF Q > P THEN
        A[Q] := #192;
    END;
    WHILE A[Length(A)] = #196 DO
      DEC(A[0]);
    DisposeStr(PA);
    DirCol.AtPut(PRED(W), NewStr(A));
    PA := PB;
    A := B;
    OldA := OldB;
    INC(W);
  END; {WHILE W}
  P := POS(#195, B);
  IF P > 0 THEN
    B[P] := #192;
  WHILE B[Length(B)] = #196 DO
    DEC(B[0]);
  DisposeStr(PB);
  DirCol.AtPut(PRED(W), NewStr(B));
{ Writeln('Memory :  ',MemAvail,',  ',MaxAvail,',  ',DirSize);}
(*
  { now delete the redundant directories }
  FOR W := PRED(DirCol.count) DOWNTO 0 DO BEGIN
    A := PString(DirCol.At(W))^;
    IF A[Length(A)] = ',' THEN
      DirCol.AtDelete(W);
  END;
*)
  { now delete orphan branches }
  W := PRED(DirCol.count);
  IF W > 1 THEN REPEAT
    Change := False;
    IF W = PRED(DirCol.count) THEN BEGIN
      PB := PString(DirCol.At(W));
      B := PB^;
      FOR P := 1 TO Length(B) DO
        IF B[P] = #179 THEN BEGIN
          B[P] := ' ';
          Change := True;
        END;
        IF Change THEN BEGIN
          DisposeStr(PB);
          DirCol.AtPut(W, NewStr(B));
          Change := False;
        END;
    END;
    W := PRED(W);
    PA := PString(DirCol.At(W));
    A := PA^;
    FOR P := 1 TO Length(A) DO BEGIN
      IF (A[P] = #179) THEN BEGIN
        IF (P > Length(B)) OR NOT (B[P] IN [#179,#192,#195]) THEN BEGIN
          A[P] := ' ';
          Change := True;
        END;
      END;
      IF (A[P] = #195) AND (B[P] = ' ') THEN BEGIN
        A[P] := #192;
        Change := True;
      END;
    END;
    IF Change THEN BEGIN
      DisposeStr(PA);
      DirCol.AtPut(W, NewStr(A));
    END;
    B := A;
  UNTIL W = 1;  {IF W > 1 THEN REPEAT}
{ Writeln('Memory :  ',MemAvail,',  ',MaxAvail,',  ',DirSize);}
END;  { FixCol }

PROCEDURE InitDosDirCol;  { New procedure by BW }
VAR
  W: Word;
  bt: Byte;
  ThisDir,LastDir,ThisDosDir: String;
BEGIN
  DosDirCol.Init(8,8);
  FOR W := 0 TO DirCol.Count-1 DO BEGIN
    ThisDir := PString(DirCol.At(W))^;
    bt := POS(#196,ThisDir);
    IF (bt > DirNameLen+2) AND (ThisDir[bt-DirNameLen] = ' ') THEN
      MOVE(LastDir[1], ThisDir[1], bt-1);
    LastDir := ThisDir;
    ThisDosDir := ThisDir;
    bt := 2;
    WHILE bt < Length(ThisDosDir) DO BEGIN
      ThisDosDir[bt] := '\';
      INC(bt,DirNameLen);
    END;
    MOVE(ThisDosDir[2], ThisDosDir[1], Pred(Length(ThisDosDir)));
    DEC(ThisDosDir[0]);
    bt := 2;
    WHILE bt < Length(ThisDosDir) DO BEGIN
      IF ThisDosDir[bt] = #196 THEN BEGIN
        MOVE(ThisDosDir[Succ(bt)], ThisDosDir[bt], Length(ThisDosDir) - bt);
        DEC(ThisDosDir[0]);
      END ELSE
        INC(bt);
    END;
    IF ThisDosDir[Length(ThisDosDir)] = #194 THEN
      DEC(ThisDosDir[0]);
    DosDirCol.AtInsert(W, NewStr(ThisDosDir));
  END;
END;  { InitDosDirCol }

FUNCTION InitDirCol: Byte;
CONST
  Any : String[5] = ':\*.*';
VAR
  Mask: PathStr;
  Er: Byte;
BEGIN
  DirCount := 0;
  DirSize := 0;
  DirCol.Init(8,8);
  GetDir(0, Mask);
  MOVE(Any[1], Mask[2], 5);
  Mask[0] := #6;
{$IFDEF NoFile}
  Mask := 'D:\*.';
{$ENDIF}
  Er := AllSearcher(Mask, Archive OR Directory, StoreName);
  IF Er = 0 THEN
    FixCol;
  InitDirCol := Er;
END;  { InitDirCol }

PROCEDURE SaveDirCol(FileName: String);
VAR
  T: TDosStream;
  W: Word;
BEGIN
  T.Init(FileName, stCreate);
  DirCol.Store(T);
  T.Done;
END;  { SaveDirCol }

FUNCTION LoadDirCol(FileDir, FileName: String; Rebuild: Boolean): Byte;
VAR
  T : TDosStream;
  Er: Byte;
  DS: DirStr;
  NS: NameStr;
  ES: ExtStr;
  SR: SearchRec;
BEGIN
  FindFirst(FileDir+FileName, AnyFile, SR);
  IF (DosError = 0) AND NOT Rebuild THEN BEGIN
    Writeln('Reading file...');
    T.Init(FileDir+FileName, stOpenRead);
    DirCol.Init(8,8);
    DirCol.Load(T);
    T.Done;
    Er := 0;
  END ELSE BEGIN
    FSPlit(FileDir+FileName,DS,NS,ES);
    DEC(DS[0]);
    FindFirst(DS,AnyFile,SR);
    IF DosError <> 0 THEN BEGIN
      Writeln('Creating directory ',DS);
      MkDir(DS);
    END;
    Writeln('Scanning directories...');
    Er := InitDirCol;
    IF Er = 0 THEN BEGIN
      Writeln('Saving directory info');
      SaveDirCol(FileDir+FileName);
    END;
  END;
  IF Er = 0 THEN
    InitDosDirCol;
  LoadDirCol := Er;
END;  { LoadDirCol }

END.
